set echo off
set feedback off
set linesize 512

prompt
prompt All Partitioned Indexes in Database
prompt

break on INDEX_OWNER skip 1 on TABLE_NAME on INDEX_NAME

SELECT	 IP.INDEX_OWNER, IX.TABLE_OWNER || '.' || IX.TABLE_NAME "OWNER.TABLE", IP.INDEX_NAME, IP.PARTITION_NAME,
		 IP.PARTITION_POSITION, IP.BLEVEL, IP.CLUSTERING_FACTOR, IP.DISTINCT_KEYS,
		 IP.NUM_ROWS, IP.PCT_FREE, IP.INI_TRANS, IP.MAX_TRANS, IP.INITIAL_EXTENT,
		 IP.NEXT_EXTENT, IP.MIN_EXTENT, IP.MAX_EXTENT, IP.PCT_INCREASE, IP.STATUS,
		 IP.LEAF_BLOCKS, IP.AVG_LEAF_BLOCKS_PER_KEY, IP.AVG_DATA_BLOCKS_PER_KEY,
		 IP.SAMPLE_SIZE, IP.LAST_ANALYZED
	FROM DBA_INDEXES IX,
	     DBA_IND_PARTITIONS IP
   WHERE IX.OWNER NOT IN ('SYS','SYSTEM','OUTLN','DBSNMP')
	 AND IX.TABLE_OWNER NOT IN ('SYS','SYSTEM','OUTLN','DBSNMP')
	 AND IX.PARTITIONED = 'YES'
     AND IP.INDEX_OWNER NOT IN ('SYS','SYSTEM','OUTLN','DBSNMP')
	 AND IP.INDEX_OWNER = IX.OWNER
	 AND IP.INDEX_NAME = IX.INDEX_NAME  
ORDER BY 1, 2, 3;